/* 
  Funkcija: validateForm()
  Apraksts: Validē formu pirms datu nosūtīšanas uz serveri.
  Pārbauda obligātos laukus, teksta garumu, datuma korektumu, 
  kā arī izceļ kļūdainos laukus ar krāsu un izvada paziņojumus.
*/
function validateForm() {
  // Noņem iepriekšējās kļūdu krāsas
  const inputs = ["fname", "lname", "cars", "date"];
  inputs.forEach(id => document.getElementById(id).classList.remove("error"));

  // Saņem laukus
  const fname = document.getElementById("fname");
  const lname = document.getElementById("lname");
  const cars = document.getElementById("cars");
  const date = document.getElementById("date");

  let valid = true;
  let message = "";

  // a. Pārbaude — obligātie lauki
  if (fname.value.trim() === "") {
    message += "Ievadiet vārdu.\n";
    fname.classList.add("error");
    valid = false;
  }
  if (lname.value.trim() === "") {
    message += "Ievadiet uzvārdu.\n";
    lname.classList.add("error");
    valid = false;
  }
  if (cars.value === "") {
    message += "Izvēlieties automašīnu.\n";
    cars.classList.add("error");
    valid = false;
  }

  // b. Teksta garuma pārbaude (>5, bez tukšumiem)
  if (fname.value.trim().length <= 5) {
    message += "Vārdam jābūt garākam par 5 simboliem.\n";
    fname.classList.add("error");
    valid = false;
  }
  if (lname.value.trim().length <= 5) {
    message += "zvārdam jābūt garākam par 5 simboliem.\n";
    lname.classList.add("error");
    valid = false;
  }

  // c, e, f. Datuma pārbaude
  const today = new Date();
  const selectedDate = new Date(date.value);
  const minDate = new Date(today);
  minDate.setFullYear(today.getFullYear() - 20);

  if (isNaN(selectedDate.getTime())) {
    message += "Lūdzu, ievadiet derīgu datumu.\n";
    date.classList.add("error");
    valid = false;
  } else if (selectedDate > today) {
    message += "Datums nevar būt lielāks par šodienu.\n";
    date.classList.add("error");
    valid = false;
  } else if (selectedDate < minDate) {
    message += "Datums nevar būt mazāks par šodienu mīnus 20 gadi.\n";
    date.classList.add("error");
    valid = false;
  }

  // Ja kāda pārbaude neizieta, izvada paziņojumu
  if (!valid) {
    alert("Lūdzu, izlabojiet kļūdas:\n\n" + message);
  }

  return valid; // ja false – forma netiek nosūtīta
}
